/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.easyminecraftgoals.v1_19_R3.packets;

import com.google.common.collect.Sets;
import com.magmaguy.easyminecraftgoals.internal.PacketEntityInterface;
import com.magmaguy.easyminecraftgoals.v1_19_R3.packets.PacketBundle;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public abstract class AbstractPacketEntity<T extends bfh>
implements PacketEntityInterface {
    protected final T entity;
    private final Set<UUID> viewers = Sets.newConcurrentHashSet();
    private final List<Runnable> removeCallbacks = new LinkedList<Runnable>();
    protected boolean visible = true;

    public List<Player> getViewersAsPlayers() {
        ArrayList<Player> players = new ArrayList<Player>();
        for (UUID viewer : this.viewers) {
            Player player = Bukkit.getPlayer((UUID)viewer);
            if (player == null) continue;
            players.add(player);
        }
        return players;
    }

    public boolean hasViewers() {
        return !this.viewers.isEmpty();
    }

    protected AbstractPacketEntity(Location location) {
        this.entity = this.createEntity(location);
    }

    protected abstract T createEntity(Location var1);

    public void addViewer(UUID player) {
        this.viewers.add(player);
    }

    public void removeViewer(UUID player) {
        this.viewers.remove(player);
    }

    public void addRemoveCallback(Runnable callback) {
        this.removeCallbacks.add(callback);
    }

    protected cmi getNMSLevel(Location location) {
        return ((CraftWorld)location.getWorld()).getHandle();
    }

    public T getNMSEntity() {
        return this.entity;
    }

    public <B extends Entity> B getBukkitEntity() {
        return (B)this.entity.getBukkitEntity();
    }

    public Location getLocation() {
        return new Location((World)((bfh)this.entity).H.getWorld(), this.entity.dl(), this.entity.dn(), this.entity.dr(), this.entity.dw(), this.entity.dy());
    }

    public UUID getUniqueId() {
        return this.entity.cs();
    }

    protected vb<?> createEntityDataPacket() {
        List dataValues = this.entity.aj().c();
        if (dataValues == null) {
            return null;
        }
        return new yj(this.entity.af(), dataValues);
    }

    public vb<?> generateRemovePacket() {
        return new xp(new int[]{this.entity.af()});
    }

    public void remove() {
        this.sendPacket(this.generateRemovePacket());
        this.removeCallbacks.forEach(Runnable::run);
    }

    public vb<?> generateSetVisiblePacket(boolean visible) {
        this.visible = visible;
        if (visible) {
            return this.createEntityDataPacket();
        }
        return new xp(new int[]{this.entity.af()});
    }

    public void setVisible(boolean visible) {
        this.sendPacket(this.generateSetVisiblePacket(visible));
    }

    public vb<?> generateHideFromPacket(UUID uuid) {
        if (!this.viewers.contains(uuid)) {
            return null;
        }
        this.removeViewer(uuid);
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return null;
        }
        return new xp(new int[]{this.entity.af()});
    }

    public void hideFrom(UUID uuid) {
        this.sendPacket(this.generateHideFromPacket(uuid));
    }

    public List<vb<?>> generateDisplayToPackets(Player player) {
        ArrayList packets = new ArrayList();
        if (this.viewers.contains(player.getUniqueId())) {
            return packets;
        }
        this.addViewer(player.getUniqueId());
        packets.add((vb<?>)new vf(this.entity.af(), this.entity.cs(), this.entity.dl(), this.entity.dn(), this.entity.dr(), this.entity.dy(), this.entity.dw(), this.entity.ae(), 0, new ede(0.0, 0.0, 0.0), 0.0));
        packets.add(this.createEntityDataPacket());
        return packets;
    }

    public void displayTo(Player player) {
        this.generateDisplayToPackets(player).forEach(packet -> this.sendPacket(player, (vb<?>)packet));
    }

    public void teleport(Location location) {
        this.entity.b(location.getX(), location.getY(), location.getZ());
        this.sendTeleportPacket();
    }

    protected void sendTeleportPacket() {
        this.sendPacket(this.generateTeleportPacket());
    }

    protected vb<?> generateTeleportPacket() {
        return new zf(this.entity);
    }

    public vb generateMovePacket(Location location) {
        double deltaZ;
        double deltaY;
        Location oldPos = this.getLocation();
        this.entity.e(location.getX(), location.getY(), location.getZ());
        this.entity.f(location.getYaw());
        this.entity.e(location.getPitch());
        vb movePacket = null;
        if (this.viewers.isEmpty()) {
            return movePacket;
        }
        Location newPos = this.getLocation();
        if (oldPos.getWorld() != newPos.getWorld()) {
            return this.generateTeleportPacket();
        }
        double deltaX = newPos.getX() - oldPos.getX();
        if (deltaX * deltaX + (deltaY = newPos.getY() - oldPos.getY()) * deltaY + (deltaZ = newPos.getZ() - oldPos.getZ()) * deltaZ > 256.0) {
            return this.generateTeleportPacket();
        }
        return new wy.b(this.entity.af(), (short)(deltaX * 4096.0), (short)(deltaY * 4096.0), (short)(deltaZ * 4096.0), (byte)(newPos.getYaw() * 256.0f / 360.0f), (byte)(newPos.getPitch() * 256.0f / 360.0f), true);
    }

    public void move(Location location) {
        this.sendPacket(this.generateMovePacket(location));
    }

    protected void sendPacket(Player player, vb<?> ... nmsPackets) {
        aiq nmsPlayer = this.getNMSPlayer(player);
        for (vb<?> nmsPacket : nmsPackets) {
            if (nmsPacket == null) continue;
            nmsPlayer.b.a(nmsPacket);
        }
    }

    protected void sendPacket(vb<?> nmsPacket) {
        for (UUID viewer : this.viewers) {
            Player player = Bukkit.getPlayer((UUID)viewer);
            if (player == null) {
                this.viewers.remove(viewer);
                continue;
            }
            this.sendPacket(player, nmsPacket);
        }
    }

    public PacketBundle createPacketBundle() {
        return new PacketBundle();
    }

    protected aiq getNMSPlayer(Player bukkitPlayer) {
        return ((CraftPlayer)bukkitPlayer).getHandle();
    }
}

