/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.easyminecraftgoals.v1_19_R3.packets;

import com.magmaguy.easyminecraftgoals.internal.AbstractPacketBundle;
import com.magmaguy.easyminecraftgoals.internal.PacketModelEntity;
import com.magmaguy.easyminecraftgoals.v1_19_R3.packets.AbstractPacketEntity;
import com.magmaguy.easyminecraftgoals.v1_19_R3.packets.PacketBundle;
import java.util.UUID;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.world.entity.EntityTypes;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.util.EulerAngle;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PacketDisplayEntity
extends AbstractPacketEntity<bfg.j>
implements PacketModelEntity {
    private ItemStack leatherHorseArmor;
    private cfv nmsLeatherHorseArmor;
    private bfg.j itemDisplay;

    public PacketDisplayEntity(Location location) {
        super(location);
    }

    private static Quaternionf eulerToQuaternion(double originalX, double originalY, double originalZ) {
        double yaw = Math.toRadians(originalZ);
        double pitch = Math.toRadians(originalY);
        double roll = Math.toRadians(originalX);
        double cy = Math.cos(yaw * 0.5);
        double sy = Math.sin(yaw * 0.5);
        double cp = Math.cos(pitch * 0.5);
        double sp = Math.sin(pitch * 0.5);
        double cr = Math.cos(roll * 0.5);
        double sr = Math.sin(roll * 0.5);
        double w = cr * cp * cy + sr * sp * sy;
        double x = sr * cp * cy - cr * sp * sy;
        double y = cr * sp * cy + sr * cp * sy;
        double z = cr * cp * sy - sr * sp * cy;
        return new Quaternionf(x, y, z, w);
    }

    @Override
    protected bfg.j createEntity(Location location) {
        return new bfg.j(EntityTypes.ae, this.getNMSLevel(location));
    }

    public void initializeModel(Location location, int modelID) {
        this.itemDisplay = (bfg.j)this.entity;
        this.itemDisplay.c(-1);
        this.itemDisplay.b(1);
        this.leatherHorseArmor = new ItemStack(Material.LEATHER_HORSE_ARMOR);
        LeatherArmorMeta itemMeta = (LeatherArmorMeta)this.leatherHorseArmor.getItemMeta();
        itemMeta.setCustomModelData(Integer.valueOf(modelID));
        itemMeta.setColor(Color.WHITE);
        this.leatherHorseArmor.setItemMeta((ItemMeta)itemMeta);
        this.nmsLeatherHorseArmor = CraftItemStack.asNMSCopy((ItemStack)this.leatherHorseArmor);
        this.itemDisplay.a(this.nmsLeatherHorseArmor);
    }

    public void setHorseLeatherArmorColor(Color color) {
        LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)this.leatherHorseArmor.getItemMeta();
        leatherArmorMeta.setColor(color);
        this.leatherHorseArmor.setItemMeta((ItemMeta)leatherArmorMeta);
        this.nmsLeatherHorseArmor = CraftItemStack.asNMSCopy((ItemStack)this.leatherHorseArmor);
        this.itemDisplay.a(this.nmsLeatherHorseArmor);
    }

    public void sendLocationAndRotationPacket(Location location, EulerAngle eulerAngle) {
        this.move(location);
        Quaternionf quaternionf = PacketDisplayEntity.eulerToQuaternion(Math.toDegrees(eulerAngle.getX()), Math.toDegrees(eulerAngle.getY()), Math.toDegrees(eulerAngle.getZ()));
        this.rotate(quaternionf);
        this.sendPacket(this.createEntityDataPacket());
    }

    public void sendLocationAndRotationAndScalePacket(Location location, EulerAngle eulerAngle, float scale) {
        this.generateLocationAndRotationAndScalePackets(new PacketBundle(), location, eulerAngle, scale).send();
    }

    public AbstractPacketBundle generateLocationAndRotationAndScalePackets(AbstractPacketBundle packetBundle, Location location, EulerAngle eulerAngle, float scale) {
        packetBundle.addPacket((Object)this.generateMovePacket(location), this.getViewersAsPlayers());
        Quaternionf quaternionf = PacketDisplayEntity.eulerToQuaternion(Math.toDegrees(eulerAngle.getX()), Math.toDegrees(eulerAngle.getY()), Math.toDegrees(eulerAngle.getZ()));
        j transformation = this.getTransformation();
        transformation = new j(transformation.d(), quaternionf, new Vector3f(scale, scale, scale), transformation.g());
        ((bfg.j)this.entity).a(transformation);
        packetBundle.addPacket(this.createEntityDataPacket(), this.getViewersAsPlayers());
        return packetBundle;
    }

    @Override
    public void displayTo(Player player) {
        super.displayTo(player);
    }

    public void displayTo(UUID player) {
        this.displayTo(Bukkit.getPlayer((UUID)player));
    }

    @Override
    public void addViewer(UUID player) {
        super.addViewer(player);
        this.displayTo(player);
    }

    public Vector3f getScale() {
        return this.getTransformation().f();
    }

    public void setScale(float scale) {
        this.setScale(new Vector3f(scale, scale, scale));
    }

    public void setScale(Vector3f scale) {
        j transformation = this.getTransformation();
        j newTransformation = new j(transformation.d(), transformation.e(), scale, transformation.g());
        this.setTransformation(newTransformation);
    }

    public Vector3f getTranslation() {
        return this.getTransformation().d();
    }

    public void setTranslation(Vector3f translation) {
        j transformation = this.getTransformation();
        j newTransformation = new j(translation, transformation.e(), transformation.f(), transformation.g());
        this.setTransformation(newTransformation);
    }

    public Quaternionf getLeftRotation() {
        return this.getTransformation().e();
    }

    public void setLeftRotation(Quaternionf rotation) {
        j transformation = this.getTransformation();
        j newTransformation = new j(transformation.d(), rotation, transformation.f(), transformation.g());
        this.setTransformation(newTransformation);
    }

    public Quaternionf getRightRotation() {
        return this.getTransformation().g();
    }

    public void setRightRotation(Quaternionf rotation) {
        j transformation = this.getTransformation();
        j newTransformation = new j(transformation.d(), transformation.e(), transformation.f(), rotation);
        this.setTransformation(newTransformation);
    }

    public j getTransformation() {
        j nms = bfg.a((DataWatcher)((bfg.j)this.entity).aj());
        return new j(nms.d(), nms.e(), nms.f(), nms.g());
    }

    private void setTransformation(j transformation) {
        ((bfg.j)this.entity).a(transformation);
    }

    private void rotate(Quaternionf rotation) {
        if (rotation == null) {
            return;
        }
        this.setLeftRotation(rotation);
    }
}

