/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.easyminecraftgoals.v1_19_R3.wanderbacktopoint;

import com.google.common.collect.ImmutableList;
import com.magmaguy.easyminecraftgoals.NMSManager;
import com.magmaguy.easyminecraftgoals.events.WanderBackToPointEndEvent;
import com.magmaguy.easyminecraftgoals.events.WanderBackToPointStartEvent;
import com.magmaguy.easyminecraftgoals.internal.AbstractWanderBackToPoint;
import com.magmaguy.easyminecraftgoals.utils.Utils;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class WanderBackToPointBehavior
extends bhp<bfx>
implements AbstractWanderBackToPoint {
    private final Location returnLocation;
    private final double maximumDistanceFromPoint;
    private final LivingEntity livingEntity;
    private final bfz mob;
    private final int maxDurationTicks;
    private long lastTime;
    private int priority;
    private float speed;
    private int stopReturnDistance = 0;
    private int goalRefreshCooldownTicks = 60;
    private boolean hardObjective = false;
    private boolean teleportOnFail = false;
    private boolean startWithCooldown = false;
    private dwz path = null;

    public WanderBackToPointBehavior(LivingEntity livingEntity, bfz mob, Location location, double maximumDistanceFromPoint, int priority, int maxDurationTicks) {
        super(Map.of(boz.m, bpa.c), 0, maxDurationTicks);
        this.livingEntity = livingEntity;
        this.mob = mob;
        this.returnLocation = location;
        this.maximumDistanceFromPoint = maximumDistanceFromPoint;
        this.maxDurationTicks = maxDurationTicks;
        this.priority = priority;
        this.lastTime = 0L;
    }

    protected boolean a(aip var0, bfx nmsLivingEntity) {
        if (!this.hardObjective && this.mob.P_() instanceof bym) {
            this.updateCooldown();
            return false;
        }
        if (this.lastTime + 50L * (long)this.goalRefreshCooldownTicks - System.currentTimeMillis() > 0L) {
            return false;
        }
        this.updateCooldown();
        if (Utils.distanceShorterThan((Vector)this.returnLocation.toVector(), (Vector)this.livingEntity.getLocation().toVector(), (double)this.maximumDistanceFromPoint)) {
            return false;
        }
        WanderBackToPointStartEvent wanderBackToPointStartEvent = new WanderBackToPointStartEvent(this.hardObjective, this.livingEntity, (AbstractWanderBackToPoint)this);
        Bukkit.getPluginManager().callEvent((Event)wanderBackToPointStartEvent);
        if (wanderBackToPointStartEvent.isCancelled()) {
            return false;
        }
        this.path = ((bgg)nmsLivingEntity).G().a(this.returnLocation.getX(), this.returnLocation.getY(), this.returnLocation.getZ(), this.stopReturnDistance);
        if (this.teleportOnFail && (this.path == null || !this.path.j())) {
            this.path = null;
            this.livingEntity.teleport(this.returnLocation);
            WanderBackToPointEndEvent wanderBackToPointEndEvent = new WanderBackToPointEndEvent(this.hardObjective, this.livingEntity, (AbstractWanderBackToPoint)this);
            Bukkit.getPluginManager().callEvent((Event)wanderBackToPointEndEvent);
            return false;
        }
        return true;
    }

    protected void d(aip var0, bfx var1, long var2) {
        this.mob.G().n();
        this.mob.G().a(this.path, (double)this.speed);
        this.mob.dH().a(bzx.a);
        if (this.hardObjective) {
            new BukkitRunnable(){

                public void run() {
                    if (!WanderBackToPointBehavior.this.livingEntity.isValid() || WanderBackToPointBehavior.this.mob.G().l() || WanderBackToPointBehavior.this.path == null || !WanderBackToPointBehavior.this.path.j()) {
                        this.cancel();
                        if (WanderBackToPointBehavior.this.livingEntity.isValid() && (WanderBackToPointBehavior.this.path == null || !WanderBackToPointBehavior.this.path.j()) && WanderBackToPointBehavior.this.teleportOnFail) {
                            WanderBackToPointBehavior.this.livingEntity.teleport(WanderBackToPointBehavior.this.returnLocation);
                        }
                        return;
                    }
                    WanderBackToPointBehavior.this.mob.G().a(WanderBackToPointBehavior.this.path, (double)WanderBackToPointBehavior.this.speed);
                }
            }.runTaskTimer(NMSManager.pluginProvider, 0L, 1L);
        }
    }

    protected void b(aip var0, bfx var1, long var2) {
        this.path = null;
        if (this.teleportOnFail && this.a(this.maxDurationTicks)) {
            this.livingEntity.teleport(this.returnLocation);
        }
        WanderBackToPointEndEvent wanderBackToPointEndEvent = new WanderBackToPointEndEvent(this.hardObjective, this.livingEntity, (AbstractWanderBackToPoint)this);
        Bukkit.getPluginManager().callEvent((Event)wanderBackToPointEndEvent);
        this.updateCooldown();
        this.mob.v(true);
    }

    protected boolean a(aip var0, bfx var1, long var2) {
        this.mob.i(null);
        if (this.path == null) {
            return false;
        }
        if (!this.hardObjective && this.mob.P_() instanceof bym) {
            return false;
        }
        return !this.path.c();
    }

    public double getMaximumDistanceFromPoint() {
        return this.maximumDistanceFromPoint;
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public LivingEntity getLivingEntity() {
        return this.livingEntity;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getMaxDurationTicks() {
        return this.maxDurationTicks;
    }

    public float getSpeed() {
        return this.speed;
    }

    public AbstractWanderBackToPoint setSpeed(float speed) {
        this.speed = speed;
        return this;
    }

    public Location getReturnLocation() {
        return this.returnLocation;
    }

    public int getStopReturnDistance() {
        return this.stopReturnDistance;
    }

    public AbstractWanderBackToPoint setStopReturnDistance(int distance) {
        this.stopReturnDistance = distance;
        return this;
    }

    public int getGoalRefreshCooldownTicks() {
        return this.goalRefreshCooldownTicks;
    }

    public AbstractWanderBackToPoint setGoalRefreshCooldownTicks(int ticks) {
        this.goalRefreshCooldownTicks = ticks;
        return this;
    }

    public boolean isHardObjective() {
        return this.hardObjective;
    }

    public AbstractWanderBackToPoint setHardObjective(boolean hardObjective) {
        this.priority = -1;
        this.hardObjective = hardObjective;
        return this;
    }

    public boolean isTeleportOnFail() {
        return this.teleportOnFail;
    }

    public AbstractWanderBackToPoint setTeleportOnFail(boolean teleportOnFail) {
        this.teleportOnFail = teleportOnFail;
        return this;
    }

    public boolean isStartWithCooldown() {
        return this.startWithCooldown;
    }

    public AbstractWanderBackToPoint setStartWithCooldown(boolean startWithCooldown) {
        this.startWithCooldown = startWithCooldown;
        return this;
    }

    public void updateCooldown() {
        this.lastTime = System.currentTimeMillis();
    }

    public void register() {
        if (this.startWithCooldown) {
            this.updateCooldown();
        }
        this.mob.dH().a(bzx.a, this.priority, ImmutableList.of((Object)((Object)this)));
    }

    public void unregister() {
    }
}

