/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.betterstructures.commands;

import com.magmaguy.betterstructures.util.ChunkPregenerator;
import com.magmaguy.magmacore.command.AdvancedCommand;
import com.magmaguy.magmacore.command.CommandData;
import com.magmaguy.magmacore.command.SenderType;
import com.magmaguy.magmacore.command.arguments.ICommandArgument;
import com.magmaguy.magmacore.command.arguments.IntegerCommandArgument;
import com.magmaguy.magmacore.command.arguments.ListStringCommandArgument;
import com.magmaguy.magmacore.util.Logger;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class PregenerateCommand
extends AdvancedCommand {
    public PregenerateCommand() {
        super(List.of("pregenerate"));
        this.addArgument("center", (ICommandArgument)new ListStringCommandArgument(List.of("HERE", "WORLD_CENTER", "WORLD_SPAWN"), "Center of the generation"));
        this.addArgument("shape", (ICommandArgument)new ListStringCommandArgument(List.of("SQUARE", "CIRCLE"), "Shape of the generation"));
        this.addArgument("radius", (ICommandArgument)new IntegerCommandArgument("Radius in blocks to generate"));
        this.addArgument("setWorldBorder", (ICommandArgument)new ListStringCommandArgument(List.of("TRUE", "FALSE"), "Set a world border at the end?"));
        this.setUsage("/betterstructures pregenerate <centerType> <shape> <radiusInBlocks> <applyWorldBorder>");
        this.setPermission("betterstructures.*");
        this.setDescription("Pregenerates chunks from a center point outward in either a square or circle pattern up to the specified radius in blocks.");
        this.setSenderType(SenderType.PLAYER);
    }

    public void execute(CommandData commandData) {
        Location center;
        String centerArg = commandData.getStringArgument("center");
        String shape = commandData.getStringArgument("shape");
        int radius = commandData.getIntegerArgument("radius");
        String setWorldBorderArg = commandData.getStringArgument("setWorldBorder");
        if (radius < 0) {
            Logger.sendMessage((CommandSender)commandData.getCommandSender(), (String)"&cRadius must be 0 or greater.");
            return;
        }
        World world = commandData.getPlayerSender().getWorld();
        switch (centerArg.toUpperCase()) {
            case "HERE": {
                center = commandData.getPlayerSender().getLocation();
                break;
            }
            case "WORLD_CENTER": {
                center = new Location(world, 0.0, (double)world.getHighestBlockYAt(0, 0), 0.0);
                break;
            }
            case "WORLD_SPAWN": {
                center = world.getSpawnLocation();
                break;
            }
            default: {
                Logger.sendMessage((CommandSender)commandData.getCommandSender(), (String)"&cInvalid center argument. Use HERE, WORLD_CENTER, or WORLD_SPAWN.");
                return;
            }
        }
        boolean setWorldBorder = "TRUE".equalsIgnoreCase(setWorldBorderArg);
        if (!"SQUARE".equalsIgnoreCase(shape) && !"CIRCLE".equalsIgnoreCase(shape)) {
            Logger.sendMessage((CommandSender)commandData.getCommandSender(), (String)"&cInvalid shape. Use SQUARE or CIRCLE.");
            return;
        }
        int radiusInBlocks = radius;
        int radiusInChunks = (int)Math.ceil((double)radiusInBlocks / 16.0);
        Logger.sendMessage((CommandSender)commandData.getCommandSender(), (String)("&2Starting chunk pregeneration with shape: " + shape + ", center: " + centerArg + ", radius: " + radiusInBlocks + " blocks (" + radiusInChunks + " chunks)"));
        if (setWorldBorder) {
            Logger.sendMessage((CommandSender)commandData.getCommandSender(), (String)"&2World border will be set to match the generated area.");
        }
        Logger.sendMessage((CommandSender)commandData.getCommandSender(), (String)"&7Progress will be reported in the console every 30 seconds.");
        Logger.sendMessage((CommandSender)commandData.getCommandSender(), (String)"&7Use &2/betterstructures cancelPregenerate &7to cancel if needed.");
        ChunkPregenerator pregenerator = new ChunkPregenerator(world, center, shape, radiusInBlocks, radiusInChunks, setWorldBorder);
        pregenerator.start();
    }
}

