/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.betterstructures.commands;

import com.magmaguy.betterstructures.config.modulegenerators.ModuleGeneratorsConfig;
import com.magmaguy.betterstructures.config.modulegenerators.ModuleGeneratorsConfigFields;
import com.magmaguy.betterstructures.modules.WFCGenerator;
import com.magmaguy.magmacore.command.AdvancedCommand;
import com.magmaguy.magmacore.command.CommandData;
import com.magmaguy.magmacore.command.SenderType;
import com.magmaguy.magmacore.command.arguments.ICommandArgument;
import com.magmaguy.magmacore.command.arguments.ListStringCommandArgument;
import com.magmaguy.magmacore.util.Logger;
import java.util.List;
import org.bukkit.command.CommandSender;

public class GenerateModulesCommand
extends AdvancedCommand {
    public GenerateModulesCommand() {
        super(List.of("generateModules"));
        this.setUsage("/bs generateModules <ModuleGeneratorsConfigFile.yml>");
        this.addArgument("moduleGeneratorsConfigFile", (ICommandArgument)new ListStringCommandArgument(ModuleGeneratorsConfig.getModuleGenerators().keySet().stream().toList(), "<module.yml>"));
        this.setPermission("betterstructures.generatemodules");
        this.setDescription("Generates modular builds in a dedicated world, based on the generator's configuration file.");
        this.setSenderType(SenderType.PLAYER);
    }

    public void execute(CommandData commandData) {
        ModuleGeneratorsConfigFields moduleGeneratorsConfigFields = ModuleGeneratorsConfig.getModuleGenerators().get(commandData.getStringArgument("moduleGeneratorsConfigFile"));
        if (moduleGeneratorsConfigFields == null) {
            Logger.sendMessage((CommandSender)commandData.getCommandSender(), (String)("File " + commandData.getStringArgument("moduleGeneratorsConfigFile") + " not found! The world won't generate."));
            return;
        }
        WFCGenerator.generateFromConfig(moduleGeneratorsConfigFields, commandData.getPlayerSender());
    }
}

