/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.betterstructures.content;

import com.magmaguy.betterstructures.MetadataHandler;
import com.magmaguy.betterstructures.config.contentpackages.ContentPackageConfigFields;
import com.magmaguy.betterstructures.config.schematics.SchematicConfig;
import com.magmaguy.betterstructures.config.schematics.SchematicConfigField;
import com.magmaguy.magmacore.menus.ContentPackage;
import com.magmaguy.magmacore.util.ItemStackGenerator;
import com.magmaguy.magmacore.util.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BSPackage
extends ContentPackage {
    private static final Map<String, BSPackage> bsPackages = new HashMap<String, BSPackage>();
    private static final String schematicFolder = MetadataHandler.PLUGIN.getDataFolder().getAbsolutePath() + File.separatorChar + "schematics" + File.separatorChar;
    private static final String modulesFolder = MetadataHandler.PLUGIN.getDataFolder().getAbsolutePath() + File.separatorChar + "modules" + File.separatorChar;
    private final ContentPackageConfigFields contentPackageConfigFields;

    public BSPackage(ContentPackageConfigFields contentPackageConfigFields) {
        this.contentPackageConfigFields = contentPackageConfigFields;
        bsPackages.put(contentPackageConfigFields.getFilename(), this);
    }

    public static void shutdown() {
        bsPackages.clear();
    }

    protected void doInstall(Player player) {
        player.closeInventory();
        File folder = this.getSpecificSchematicFolder();
        if (!folder.exists()) {
            Logger.sendMessage((CommandSender)player, (String)("Failed to find directory " + folder.getAbsolutePath()));
            return;
        }
        for (File file : folder.listFiles()) {
            if (!file.getName().endsWith(".yml")) continue;
            SchematicConfigField schematicConfigField = SchematicConfig.getSchematicConfiguration(file.getName());
            schematicConfigField.toggleEnabled(true);
        }
        this.contentPackageConfigFields.setEnabledAndSave(true);
        MetadataHandler.PLUGIN.onDisable();
        MetadataHandler.PLUGIN.onLoad();
        MetadataHandler.PLUGIN.onEnable();
        Logger.sendMessage((CommandSender)player, (String)" Reload attempted. This may not 100% work. Restart instead if it didn't!");
        Logger.sendMessage((CommandSender)player, (String)("Installed " + this.contentPackageConfigFields.getName()));
    }

    public void doUninstall(Player player) {
        player.closeInventory();
        File folder = this.getSpecificSchematicFolder();
        if (!folder.exists()) {
            Logger.sendMessage((CommandSender)player, (String)("Failed to find directory " + folder.getAbsolutePath()));
            return;
        }
        for (File file : folder.listFiles()) {
            if (!file.getName().endsWith(".yml")) continue;
            SchematicConfigField schematicConfigField = SchematicConfig.getSchematicConfiguration(file.getName());
            schematicConfigField.toggleEnabled(false);
        }
        this.contentPackageConfigFields.setEnabledAndSave(false);
        MetadataHandler.PLUGIN.onDisable();
        MetadataHandler.PLUGIN.onLoad();
        MetadataHandler.PLUGIN.onEnable();
        Logger.sendMessage((CommandSender)player, (String)" Reload attempted. This may not 100% work. Restart instead if it didn't!");
        Logger.sendMessage((CommandSender)player, (String)("Uninstalled " + this.contentPackageConfigFields.getName()));
    }

    public void doDownload(Player player) {
        player.closeInventory();
        player.sendMessage("----------------------------------------------------");
        Logger.sendMessage((CommandSender)player, (String)("&4Download this at &9 " + this.contentPackageConfigFields.getDownloadLink()));
        player.sendMessage("----------------------------------------------------");
    }

    protected ItemStack getInstalledItemStack() {
        ArrayList<String> lore = new ArrayList<String>(this.contentPackageConfigFields.getDescription());
        lore.addAll(List.of("Content is installed!", "Click to uninstall!"));
        return ItemStackGenerator.generateItemStack((Material)Material.GREEN_STAINED_GLASS_PANE, (String)this.contentPackageConfigFields.getName(), lore);
    }

    protected ItemStack getPartiallyInstalledItemStack() {
        ArrayList<String> lore = new ArrayList<String>(this.contentPackageConfigFields.getDescription());
        lore.addAll(List.of("Content partially installed!", "This is either because you haven't downloaded all of it,", "or because some elements have been manually disabled.", "Click to download!"));
        return ItemStackGenerator.generateItemStack((Material)Material.ORANGE_STAINED_GLASS_PANE, (String)this.contentPackageConfigFields.getName(), lore);
    }

    protected ItemStack getNotInstalledItemStack() {
        ArrayList<String> lore = new ArrayList<String>(this.contentPackageConfigFields.getDescription());
        lore.addAll(List.of("Content is not installed!", "Click to install!"));
        return ItemStackGenerator.generateItemStack((Material)Material.YELLOW_STAINED_GLASS_PANE, (String)this.contentPackageConfigFields.getName(), lore);
    }

    protected ItemStack getNotDownloadedItemStack() {
        ArrayList<String> lore = new ArrayList<String>(this.contentPackageConfigFields.getDescription());
        lore.addAll(List.of("Content is not downloaded!", "Click for download link!"));
        return ItemStackGenerator.generateItemStack((Material)Material.RED_STAINED_GLASS_PANE, (String)this.contentPackageConfigFields.getName(), lore);
    }

    protected ContentPackage.ContentState getContentState() {
        if (!this.isInstalled()) {
            return ContentPackage.ContentState.NOT_DOWNLOADED;
        }
        if (this.contentPackageConfigFields.isEnabled()) {
            return ContentPackage.ContentState.INSTALLED;
        }
        return ContentPackage.ContentState.NOT_INSTALLED;
    }

    private File getSpecificSchematicFolder() {
        return new File(schematicFolder + this.contentPackageConfigFields.getFolderName());
    }

    private boolean isInstalled() {
        if (this.contentPackageConfigFields.getContentPackageType().equals((Object)ContentPackageConfigFields.ContentPackageType.MODULAR)) {
            return new File(modulesFolder + this.contentPackageConfigFields.getFolderName()).exists();
        }
        return new File(schematicFolder + this.contentPackageConfigFields.getFolderName()).exists();
    }

    public static Map<String, BSPackage> getBsPackages() {
        return bsPackages;
    }

    public ContentPackageConfigFields getContentPackageConfigFields() {
        return this.contentPackageConfigFields;
    }
}

