/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.betterstructures.config;

import com.magmaguy.magmacore.config.ConfigurationEngine;
import com.magmaguy.magmacore.config.ConfigurationFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;

public class ValidWorldsConfig
extends ConfigurationFile {
    private static HashMap<World, Boolean> validWorlds = new HashMap();
    private static boolean whitelistNewWorlds;
    private static ValidWorldsConfig instance;

    public ValidWorldsConfig() {
        super("ValidWorlds.yml");
        instance = this;
    }

    public static void registerNewWorld(World world) {
        if (ValidWorldsConfig.instance.fileConfiguration.getKeys(true).contains("Valid worlds." + world.getName())) {
            validWorlds.put(world, ValidWorldsConfig.instance.fileConfiguration.getBoolean("Valid worlds." + world.getName()));
            return;
        }
        ConfigurationEngine.setBoolean((FileConfiguration)ValidWorldsConfig.instance.fileConfiguration, (String)("Valid worlds." + world.getName()), (boolean)whitelistNewWorlds);
        ConfigurationEngine.fileSaverOnlyDefaults((FileConfiguration)ValidWorldsConfig.instance.fileConfiguration, (File)ValidWorldsConfig.instance.file);
        validWorlds.put(world, whitelistNewWorlds);
    }

    public static boolean isValidWorld(World world) {
        if (validWorlds.get(world) != null) {
            return validWorlds.get(world);
        }
        return false;
    }

    public void initializeValues() {
        whitelistNewWorlds = ConfigurationEngine.setBoolean((FileConfiguration)this.fileConfiguration, (String)"New worlds spawn structures", (boolean)true);
        for (World world : Bukkit.getWorlds()) {
            ConfigurationEngine.setBoolean((FileConfiguration)this.fileConfiguration, (String)("Valid worlds." + world.getName()), (boolean)true);
        }
        ConfigurationSection validWorldsSection = this.fileConfiguration.getConfigurationSection("Valid worlds");
        ArrayList<String> enabledWorlds = new ArrayList<String>();
        for (String key : validWorldsSection.getKeys(false)) {
            if (!validWorldsSection.getBoolean(key)) continue;
            enabledWorlds.add(key);
        }
        for (World world : Bukkit.getWorlds()) {
            validWorlds.put(world, enabledWorlds.contains(world.getName()));
        }
        ConfigurationEngine.fileSaverOnlyDefaults((FileConfiguration)this.fileConfiguration, (File)this.file);
    }

    public static HashMap<World, Boolean> getValidWorlds() {
        return validWorlds;
    }

    public static boolean isWhitelistNewWorlds() {
        return whitelistNewWorlds;
    }

    public static class ValidWorldsConfigEvents
    implements Listener {
        @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
        public void onWorldLoad(WorldLoadEvent event) {
            ValidWorldsConfig.registerNewWorld(event.getWorld());
        }
    }
}

